 
 module twoportbram
    #(
        parameter                           RAM_WIDTH = 24,
        parameter                           RAM_ADDR_BITS = 16,
        parameter                           RAM_WORDS = 16'd512
    ) (
    input logic                             clk,
    input logic 			    reset,
    input logic [RAM_ADDR_BITS - 1:0]       ra, wa,
    input logic                             write, read,
    input logic [RAM_WIDTH - 1:0]           data_in,
    output logic [RAM_WIDTH - 1:0]          data_out
    );

    logic [RAM_WIDTH - 1:0] mem [RAM_WORDS - 1:0];

    always_ff @(posedge clk) begin
        if (write) mem[wa] <= data_in;
        data_out <= mem[ra];
    end
endmodule
